/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.kekie6.colorfulazaleas.gameplay.loot.GenericLootTableModifier;
import com.kekie6.colorfulazaleas.registry.AzaleaBlocks;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="colorfulazaleas")
public class ColorfulAzaleasForge {
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"colorfulazaleas");
    private static final RegistryObject<Codec<GenericLootTableModifier>> COLORFUL_AZALEA_LOOT_TABLE_MODIFIER = GLOBAL_LOOT_MODIFIERS.register("colorful_azalea", GenericLootTableModifier.CODEC);
    public static final CreativeModeTab CREATIVE_TAB = new CreativeModeTab("colorfulazaleas.colorful_azaleas"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)AzaleaBlocks.trees[5].sapling.get().m_5456_());
        }
    };

    public ColorfulAzaleasForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getItemStack().m_41720_() instanceof AxeItem) {
                Level level = event.getLevel();
                BlockPos pos = event.getPos();
                BlockState state = level.m_8055_(pos);
                Optional<AzaleaBlocks.ColorfulTree> optionalTree = Arrays.stream(AzaleaBlocks.trees).filter(tree -> state.m_60713_(tree.woodType.log.get()) || state.m_60713_(tree.woodType.wood.get())).findFirst();
                if (optionalTree.isPresent()) {
                    Player player = event.getEntity();
                    level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    AzaleaBlocks.WoodType woodType = optionalTree.get().woodType;
                    if (player != null) {
                        player.m_6674_(event.getHand());
                    }
                    if (!level.f_46443_) {
                        BlockState newState = state.m_60713_(woodType.log.get()) ? (BlockState)woodType.stripped_log.get().m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))) : (BlockState)woodType.stripped_wood.get().m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)));
                        level.m_7731_(pos, newState, 11);
                        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
                        if (player != null) {
                            event.getItemStack().m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(event.getHand()));
                        }
                    }
                }
            }
        });
        ColorfulAzaleas.init();
        GLOBAL_LOOT_MODIFIERS.register(eventBus);
    }
}

